*************************************************************************************************************.
********  	WHO Child Growth Standards                                                         	  ***.
********  	Department of Nutrition for Health and Development                                 	  ***.
********  	World Health Organization                                                          	  ***.
********  	Last modified on 27/09/2006     -     For SPSS versions 13.0 and above             	  ***.
*************************************************************************************************************.
*Adaptado para MONIN REGIONAL Nov 2007.
*************************************************************************************************************.
********  	A macro / program for calculating the z-scores and prevalences for ANY nutritional survey  **.
*************************************************************************************************************.

* There are two changes necessary before using this program; first you must put the correct data file name into.
* the titles and file specs using "find and replace", and second, you must determine the correct variable.
* names for age, height, weight, etc.
* You can then run the syntax and double-check the output and generated variables to make sure they make sense.

* Do a "find and replace" of "filename" to put in the correct data file name (18 occurances).
* Also set the file location to the correct drive and subdirectory (26 occurances).
* to specify where the dataset is found.  This directory is also where the 5 *lms files.
* (hazlms.sav; wazlms.sav; wfhlms.sav; whllms.sav; bmilms.sav) are expected.
* If your files are stored elsewhere, such as "d:\user"  then do a .
* "find and replace" on all "d:\igrowup" and replace with "d:\user" .

*set mxmemory=48000.
*set header on.
*set printback=on length=None Width=132.

FILE HANDLE DATOS      /NAME='C:\06 CENAN\_CENAN\00 MONIN\02 MONIN 1997-2006\11 MONIN_consolidado1997-2006'.
FILE HANDLE WHO	        /NAME='C:\06 CENAN\_CENAN\00 MONIN'.

*--->>Ingresar nombre del archivo de datos<<------*.
GET FILE ='DATOS\zAntroNinos.sav'.

title "filename using WHO Child Growth Standards".
* ================================.
COMMENT * Here are the variables you need to give variable names for:
COMMENT * casenum=______  (this is optional, if missing you could set it to zero) .
COMMENT * wgting= ______  (if no weighting, set this to 1).
COMMENT * weight2= _____ (this is the child's weight in kg).
COMMENT * sex= ____ (1 is male, 2 is female).
COMMENT * agemos= _____ (if not given in months, it will be computed by dateinterview-dateborn).
COMMENT * length= ________ (length of the child in cm).
COMMENT * lorh= ______ (measuring length or height? L=1, H=2, if not noted, set as missing).
COMMENT * oedema= ____ (y or n, assume all as "n" in coding, otherwise change below).
COMMENT * region= _____ (country region, it is set to 1 below, unless you change it).
COMMENT * urbanr= _____ (urban or rural, it is set to 1 below, unless you change it).

COMMENT * reminder: set missing values for any variables not declared.

compute casenum=0.
compute wgting=1.
compute weight2=Peso.
compute sex=Sexo.
*compute agemos=_____.
* if date of interview and date of birth are known.
compute agemos=DATEDIFF(FecEnc,FecNac ,"months").
compute length=Talla.
compute lorh= Metodo.
*string oedema (A1).
*compute oedema='n'.
COMMENT * delete the above if oedema is in dataset.

*compute region=1.
*compute urbanr=1.
COMMENT Use the two statements above if you have no region & urban, otherwise delete.
COMMENT ELSE uncomment below, after filling blanks, if you do have region,urban.
COMMENT RENAME VARIABLES (______=REGION).
COMMENT RENAME VARIABLES (______=URBANR).
COMMENT * using RENAME allows value labels to transfer.

compute agedays3=-999.
missing values agedays3 (-999).
*if(missing(agedays3))agedays3=agemos*30.4375.
* if date of interview and date of birth are known.
 if(missing(agedays3))agedays3=DATEDIFF(FecEnc,FecNac ,"days") .

COMMENT * agedays3 will be used later to compute exact month cutoffs, and should not be rounded.

compute agedays2=rnd(agedays3).

*----------------------------------script variables multiples-----------------------------------------------------------*.
*-------------------------------------------------------------------------------------------------------------------------------*.
*            Selecciona las variables antropometricas en SPSS*.
*            INPUT: 
*            (1) Variables antropometricas:
*                  Fecha de encuesta y fecha de nacimiento o edad en meses del nino.
*                  Sexo[1=Hombre ,2=Mujer ], Peso(Kg), Talla (cms).
*                  Metodo de talla [1=echado , 2= de pie ];[1=horizontal,2=de pie];[1=longitud,2=Altura].
*--------------------------------------------------------------------------------------------------------------------------------*.
*------------------------------------loop variable por variable----------------------------------------------------------*.
*----------------------------------------------------------------------------------------------------------------------------*.
*            Determinacion de la edad del nino en meses, dias (con decimal), dias (enteros)       *.
*            INPUT: Fecha de encuesta y fecha de nacimiento o edad en meses del nino.
*----------------------------------------------------------------------------------------------------------------------------*.
*COMPUTE  zEdadMes=.
*COMPUTE zEdadDia3=-999.
*COMPUTE zEdadDia2=RND(zEdadDia3).

*----------------------------------------------------------------------------------------------------------------------------*.
*            Ajustes respecto del metodo utilizado para medir la talla del nino                                   *.
*            INPUT: edad y metodo .
*----------------------------------------------------------------------------------------------------------------------------*.

* ================== Length & Height adjustments===========================.
* take what they call length or height and create one lenhei2 variable_____________________.
* lenhei2 is the proper length/height measurement adjusted for.

* set all lengths as ok and then change those that are not ok.
compute lenhei2=length.
compute uselngth=-99.
missing values uselngth (-99).
if (missing(lenhei2)) uselngth=-99.

* if standing under 2 or lying over 2.
if (lorh=2 and agedays2<731) lenhei2=length+.7.
if (lorh=1 and agedays2>=731) lenhei2=length-.7.
if (lorh=2 and agedays2<731)uselngth=1.
if (lorh=1 and agedays2>=731) uselngth=2.
if (lorh=1 and agedays2<731)uselngth=1.
if (lorh=2 and agedays2>=731) uselngth=2.

* if missing the recumbent indicator but have age, we assume they have it right.
if (missing(lorh) and agedays2<731) uselngth=1.
if (missing(lorh) and agedays2>=731) uselngth=2.
if (missing(lorh) and missing(agedays2) and agemos<24) uselngth=1.
if (missing(lorh) and missing(agedays2) and agemos>=24) uselngth=2.
if (missing(agedays2) and lorh=2) uselngth=2.
if (missing(agedays2) and lorh=1) uselngth=1.

* if age missing and indicator missing, use length of child to figure.
if (missing(agedays2) and missing(lorh) and length<87) uselngth=1.
if (missing(agedays2) and missing(lorh) and length>=87) uselngth=2.


* ========= check inputs and create outputs for dbf file ANTHRO check =======.
frequencies variables=sex, lorh.
descriptives variables=weight2, length, lenhei2,agedays2,agedays3,agemos /statistics=mean stddev min max.

* if not done already, need age in days to compare to norms.

*next 3 statements keep only what we need (+ bit more, 61 mo), sort, save, and drop unneeded vars.
select if (agedays2 < (61*30.4375) or missing(agedays2)).
*sort to get ready to match to haz norm chart.

SORT CASES BY sex, agedays2.
*XSAVE OUTFILE='DATOS\tempx.sav'
/KEEP casenum, wgting, region,urbanr,
weight2,sex,agemos,length,lorh, oedema,
lenhei2,uselngth,agedays2,agedays3.
execute.

* ============================  HAZ  ==================================.
* lookup z formula for Height for Age  using l, m, s variables.
MATCH FILES FILE=* 
/TABLE='WHO\hazlms.sav' 
/BY sex,  agedays2.

execute.
compute zhaz=(((lenhei2/m)**l)-1)/(s*l).
execute.
*xsave outfile="d:\igrowup\tempxx.sav"
*/drop = l,m,s.
*execute.
DELE VARI l m s.
execute.
* ============================= BMI Z ===================================.
* lookup z formula for BMI for Age  using l, m, s variables.
*MATCH FILES FILE="d:\igrowup\tempxx.sav" /table="d:\igrowup\BMIlms.sav" /by sex,  agedays2.
*execute.
* make sure weight has been given right var name.
*compute BMI= weight2*10000/(lenhei2*lenhei2).
*compute zBMI=(((BMI/m)**l)-1)/(s*l).
*compute sd3pos=m*((1+l*s*3)**(1/l)).
*compute sd23pos=sd3pos- m*((1+l*s*2)**(1/l)).
*if (zBMI>3) zBMI=3+((BMI-sd3pos)/sd23pos).

*compute sd3neg=m*((1+l*s*(-3))**(1/l)).
*compute sd23neg= m*((1+l*s*(-2))**(1/l))-sd3neg.
*if (zBMI<-3) zBMI=(-3)-((sd3neg-BMI)/sd23neg).

*if (oedema='y' or oedema='Y') zbmi=-4.44.
* this makes sure oedemas aren't put in the high or low prevalence categories.
* but are still counted for denominator.
* zbmi = -4.44 with oedema will be adjusted later.


*xsave outfile="d:\igrowup\tempx.sav" /drop = l,m,s.
*execute.

* ======================== WAZ =====================================.
* lookup z formula for Weight to Age  using l, m, s variables.
sort cases by sex, agedays2.
MATCH FILES FILE=*
/TABLE='WHO\wazlms.sav' 
/BY sex, agedays2.
execute.

compute zwaz=(((weight2/m)**l)-1)/(s*l).
compute sd3pos=m*((1+l*s*3)**(1/l)).
compute sd23pos=sd3pos- m*((1+l*s*2)**(1/l)).
if (zwaz>3) zwaz=3+((weight2-sd3pos)/sd23pos).

compute sd3neg=m*((1+l*s*(-3))**(1/l)).
compute sd23neg= m*((1+l*s*(-2))**(1/l))-sd3neg.
if (zwaz<-3) zwaz=(-3)-((sd3neg-weight2)/sd23neg).

*if (oedema='y' or oedema='Y') zwaz=-4.44.
*if (missing(agedays2) and (oedema='y' or oedema='Y') ) zwaz=-4.44.
* this allows oedemas to be be set at < -3 sd for prevalences.
* then set to missing later before calculating means.
* zwaz is set to missing later.
execute.
DELE VAR l m s.
execute.
* =========================== WHZ using length ============================.

* ======== interpolate length =======.
* determine if length is of 2 decimals significance.
* since the LMS charts are only to one, such as 87 point 2.
* the interp variable =1 if we need to interpolate.

if(uselngth=1)length2=lenhei2.
compute interp=0.
if (abs(length2 - (rnd(length2*10))/10) >.001)interp=1.

* if it does then interpolate on lms table.

* first we will find the lower level on LMS chart.
DO IF interp=1.
 compute lenlow=trunc(length2*10)/10.
ELSE IF interp=0.
 compute lenlow=rnd(length2*10)/10.
* above makes double sure it will match lms chart.
END IF.

* next we will find the upper level on LMS chart.
DO IF interp=1.
 compute lenhigh=rnd((length2+.05)*10)/10.
ELSE IF interp=0.
 compute lenhigh=rnd(length2*10)/10.
END IF.

* we will be doing many calculations with length2 .
* so we will remember the original values here.
compute length9=length2.



* next we will get the LMS numbers for lenlow and lenhigh.
* ===============lenlow LMS calculations============.
compute length2=lenlow.
sort cases by sex, length2.
*xsave outfile="d:\igrowup\tempxx.sav"
 */drop = l,m,s.
*execute.

* lookup z formula for Weight for Length  using l, m, s variables.
MATCH FILES FILE=*
/table='WHO\wfllms.sav'
 /by sex, length2.
execute.


* do the lengths--> zscore for lenlow where ll=lenlow.
compute zwhzll=(((weight2/m)**l)-1)/(s*l).
compute sd3pos=m*((1+l*s*3)**(1/l)).
compute sd23pos=sd3pos- m*((1+l*s*2)**(1/l)).
if (zwhzll>3) zwhzll=3+((weight2-sd3pos)/sd23pos).

compute sd3neg=m*((1+l*s*(-3))**(1/l)).
compute sd23neg= m*((1+l*s*(-2))**(1/l))-sd3neg.
if (zwhzll<-3) zwhzll=-3-((sd3neg-weight2)/sd23neg).

execute.

DELE VARI l m s.
execute.
* ===============lenhigh LMS calculations============.
compute length2=lenhigh.
sort cases by sex, length2.
*xsave outfile="d:\igrowup\tempx.sav"
*/drop = l,m,s.
*execute.
* lookup z formula for Weight for Length  using l, m, s variables.
MATCH FILES FILE=*
/table='WHO\wfllms.sav' 
/by sex, length2.
execute.
* do the lengths--> zscore for lenhigh where lh=lenhigh.
compute zwhzlh=(((weight2/m)**l)-1)/(s*l).
compute sd3pos=m*((1+l*s*3)**(1/l)).
compute sd23pos=sd3pos- m*((1+l*s*2)**(1/l)).
if (zwhzlh>3) zwhzlh=3+((weight2-sd3pos)/sd23pos).

compute sd3neg=m*((1+l*s*(-3))**(1/l)).
compute sd23neg= m*((1+l*s*(-2))**(1/l))-sd3neg.
if (zwhzlh<-3) zwhzlh=-3-((sd3neg-weight2)/sd23neg).

* =========== calculations for height used =====.
* use criteria for when height used, height2 is height properly measured.
if (uselngth=2) height2=lenhei2.
* we will be doing many calculations with height2 .
* so we will remember the original value here.
compute height9=height2.

* determine if height is of 2 decimals significance.
* since the LMS charts are only to one, such as 87 point 2.
* the interph variable =1 if we need to interpolate.
compute interph=0.
.
if (abs(height2 - (rnd(height2*10))/10) >.001)interph=1.
* if it does then interpolate on lms table.
* first we will find the lower level on LMS chart.
DO IF interph=1.
 compute hgtlow=trunc(height2*10)/10.
ELSE IF interph=0.
 compute hgtlow=rnd(height2*10)/10.
END IF.
* next we will find the upper level on LMS chart.
DO IF interph=1.
 compute hgthigh=rnd((height2+.05)*10)/10.
ELSE IF interph=0.
 compute hgthigh=rnd(height2*10)/10.
END IF.
execute.
DELE VARI l m s.
execute.
* ===================WHZ using hgtlow ===================.
compute height2=hgtlow.
sort cases by sex, height2.
*xsave outfile="d:\igrowup\tempxx.sav" /drop = l,m,s.
*execute.

* lookup z formula for Weight for Height  using l, m, s variables.

MATCH FILES FILE=*
/table='WHO\wfhlms.sav'
 /by sex, height2.
execute.
* do the heights where hl=hgtlow.
if (height2>0) zwhzhl=(((weight2/m)**l)-1)/(s*l).
if (height2>0) sd3pos=m*((1+l*s*3)**(1/l)).
if (height2>0) sd23pos=sd3pos- m*((1+l*s*2)**(1/l)).
if (height2>0 and zwhzhl>3) zwhzhl=3+((weight2-sd3pos)/sd23pos).

if (height2>0) sd3neg=m*((1+l*s*(-3))**(1/l)).
if (height2>0) sd23neg= m*((1+l*s*(-2))**(1/l))-sd3neg.
if (height2>0 and zwhzhl<-3) zwhzhl=(-3)-((sd3neg-weight2)/sd23neg).
execute.
DELE VARI l m s.
execute.
* ===================WHZ using hgthigh ===================.
compute height2=hgthigh.
sort cases by sex, height2.
*xsave outfile="d:\igrowup\tempx.sav" /drop = l,m,s.
*execute.


* lookup z formula for Weight for Height  using l, m, s variables.

MATCH FILES FILE=* 
/table='WHO\wfhlms.sav'
 /by sex, height2.
execute.
* do the heights where hh=hgthigh.
if (height2>0) zwhzhh=(((weight2/m)**l)-1)/(s*l).
if (height2>0) sd3pos=m*((1+l*s*3)**(1/l)).
if (height2>0) sd23pos=sd3pos- m*((1+l*s*2)**(1/l)).
if (height2>0 and zwhzhh>3) zwhzhh=3+((weight2-sd3pos)/sd23pos).

if (height2>0) sd3neg=m*((1+l*s*(-3))**(1/l)).
if (height2>0) sd23neg= m*((1+l*s*(-2))**(1/l))-sd3neg.
if (height2>0 and zwhzhh<-3) zwhzhh=(-3)-((sd3neg-weight2)/sd23neg).

* =====now do interpolation and choose length or height =====.

* length9 is somewhere between lenlow and lenhigh.
* find the ratios with #s like 52,20  52,26  and 52,30.
compute abovel=length9-lenlow.
compute ratiol=abovel/.1.
* note that the greater the length, the less the z.
compute zwhz= zwhzll-((zwhzll-zwhzlh)*ratiol).
* now for height.
* height is defined only if uselngth=2 and.
*  will replace the length calculations if defined.
compute aboveh=height9-hgtlow.
compute ratioh=aboveh/.1.
* note that the greater the height,the less the z.
if (uselngth=2) zwhz= zwhzhl-((zwhzhl-zwhzhh)*ratioh).
*if (oedema='y' or oedema='Y') zwhz=-4.44.
*xsave outfile="d:\igrowup\tempxx.sav" /drop = l,m,s.
*execute.
execute.
DELE VARI l m s.
execute.

* ================ convert Z scores to 2 decimals =====================.
compute zwhz=(rnd(zwhz*100))/100.
compute zhaz=(rnd(zhaz*100))/100.
compute zwaz=(rnd(zwaz*100))/100.
*compute zbmi=(rnd(zbmi*100))/100.

* ======================== Flags for missing values ====================.
compute whzflag=0.
compute hazflag=0.
compute wazflag=0.
*compute bmiflag=0.
compute whznoage=0.

if (zwhz < -5 or zwhz >5 ) whzflag =1.
if (zhaz < -6 or zhaz >6 ) hazflag =1.
if (zwaz < -6 or zwaz >5 ) wazflag =1.
*if (zbmi < -5 or zbmi >5) bmiflag=1.

if ((zwhz < -5 or zwhz >5) and  (zhaz < -6 or zhaz >6 )) flag4 =1.
if ((zwhz < -5 or zwhz >5 ) and (zwaz < -6 or zwaz >5 )) flag5 =1.
if ((zhaz < -6 or zhaz >6 ) and (zwaz < -6 or zwaz >5 )) flag6 =1.
if ((zwhz < -5 or zwhz >5) and  (zhaz < -6 or zhaz >6 ) and (zwaz < -6 or zwaz >5 ) ) flag7 =1.
*if ((bmiflag=1) and (whzflag=0) and (hazflag=0) and (wazflag=0)) flag8=1.


* no BMI flags set as 1-7.
if (zwhz < -5 or zwhz >5 ) flagnew =1.
if (zhaz < -6 or zhaz >6 ) flagnew =2.
if (zwaz < -6 or zwaz >5 ) flagnew =3.
if ((zwhz < -5 or zwhz >5) and  (zhaz < -6 or zhaz >6 )) flagnew =4.
if ((zwhz < -5 or zwhz >5 ) and (zwaz < -6 or zwaz >5 )) flagnew =5.
if ((zhaz < -6 or zhaz >6 ) and (zwaz < -6 or zwaz >5 )) flagnew =6.
if ((zwhz < -5 or zwhz >5) and  (zhaz < -6 or zhaz >6 ) and (zwaz < -6 or zwaz >5 ) ) flagnew =7.
*if ((bmiflag=1) and (whzflag=0) and (hazflag=0) and (wazflag=0)) flagnew=8.
if(sysmis(sex)=1) flagNew=9.
* ==================declare flagged values missing=========================.

if (zwhz < -5 or zwhz >5 ) zwhz =999.99.
if (zhaz < -6 or zhaz >6 ) zhaz =999.99.
if (zwaz < -6 or zwaz >5 ) zwaz =999.99.
*if (zbmi < -5 or zbmi >5) zbmi=999.99.
*MISSING VALUES zwhz,zhaz,zwaz,zbmi (999.99).
MISSING VALUES zwhz,zhaz,zwaz (999.99).
* we copy the zscores to oedema copies for special oedema adjustments later.
*compute oedzbmi=zbmi.
*compute oedzwhz=zwhz.
*compute oedzwaz=zwaz.

*Missing values oedzwhz,oedzwaz,oedzbmi (999.99).

* we want to see how many valid whz scores are there with no age.
if(missing(agedays2) and (zwhz >=-5 and zwhz <=5)) whznoage=1.

* count flags.

*XSAVE outfile="d:\igrowup\filename_z.sav" /keep=casenum to zbmi,zwaz,zwhz,whzflag to whznoage.
*ERASE FILE='d:\igrowup\tempx.sav'.
*ERASE FILE='d:\igrowup\tempxx.sav'.
*set header on.
*set printback=on length=None Width=132.

VARI LABEL 
zhaz  'z Score Talla/Edad [OMS 2006]'
zwaz 'z Score Peso/Edad [OMS 2006]'
zwhz 'z Score Peso/Talla [OMS 2006]'
whzflag 'Peso/Talla fuera de rango[zwhz < -5 or zwhz >5]'
hazflag 'Talla/Edad fuera de rango[zhaz < -6 or zhaz >6]'
wazflag 'Peso/Edad fuera de rango[zwaz < -6 or zwaz >5]'
whznoage 'Dato de edad errado'
flag4 'Peso/Talla y Talla/Edad fuera de rango'
flag5 'Peso/Talla y Peso/Edad fuera de rango'
flag6 'Talla/Edad y Peso/Edad fuera de rango' 
flag7 'Los tres fuera de rango'
flagnew'Tipo de error'
.
VALU LABEL
 zhaz zwaz zwhz
 whzflag hazflag wazflag
 whznoage flag4 flag5 flag6  flag7 
0'No' 1'Si'.
VALUE LABEL flagnew 
0 'Antropometria completa y dentro del rango'
1 'Peso/Talla fuera de rango[zwhz < -5 or zwhz >5]'
2 'Talla/Edad fuera de rango[zhaz < -6 or zhaz >6]'
3 'Peso/Edad fuera de rango[zwaz < -6 or zwaz >5]'
4 'Peso/Talla y Talla/Edad fuera de rango'
5 'Peso/Talla y Peso/Edad fuera de rango'
6 'Talla/Edad y Peso/Edad fuera de rango'
7 'Los tres fuera de rango'
9 'Sin dato de sexo'
.

RECODE flag4 to flagNew (sysmis=0).
execute.

SAVE OUTFILE ='DATOS\zAntroNinosWHO2006.sav'
/KEEP id_enc nficha idNino FecEnc FecNac  Sexo Metodo Talla Peso
zhaz zwaz zwhz
whzflag hazflag wazflag
whznoage flag4 flag5 flag6  flag7 flagnew .
execute.


